const path = require('path');
const fs = require('fs');

function triple() {
  if (process.platform === 'win32') return `win32-${process.arch}-msvc`;
  if (process.platform === 'darwin') return `darwin-${process.arch}`;
  if (process.platform === 'linux')  return `linux-${process.arch}-gnu`; // or musl
  throw new Error(`Unsupported: ${process.platform}-${process.arch}`);
}

const fname = `native.${triple()}.node`; // adjust "native" to your base name
let p = path.join(__dirname, fname);
if (!fs.existsSync(p) && __dirname.includes('.asar')) {
  p = p.replace('app.asar', 'app.asar.unpacked');
}

if (p.includes("app.asar.unpacked")) {
  p = path.join(p.substring(0, p.indexOf("app.asar.unpacked") + "app.asar.unpacked".length), "native", fname);
}

let nativeBinding = require(p);

module.exports = nativeBinding
module.exports.getDisplays = nativeBinding.getDisplays
module.exports.loggedIn = nativeBinding.loggedIn
module.exports.sessionLocked = nativeBinding.sessionLocked
module.exports.sessionLockedCallback = nativeBinding.sessionLockedCallback